import serial
import time
import sys


SERIAL_PORT = '/dev/cu.usbmodem1201'  # diff entre mac et windows
BAUD_RATE = 115200  
OUTPUT_FILE = 'geiger_datatempsmortmicro.txt'

# Tentative de connexion série
try:
    ser = serial.Serial(SERIAL_PORT, BAUD_RATE, timeout=1)
    print(f" Connecté à {SERIAL_PORT}")
except serial.SerialException as e:
    print(f" Erreur à l’ouverture du port série : {e}")
    sys.exit()

start_time = time.time() * 1_000_000  # temps de départ en microsecondes

try:
    with open(OUTPUT_FILE, 'a') as file:
        # Écrire l'en-tête si le fichier est vide
        if file.tell() == 0:
            file.write("Elapsed Time (µs)\n")

        while True:
            line = ser.readline().decode('utf-8').strip()
            if line:  # Si une ligne a été reçue (événement détecté)
                elapsed_time_us = (time.time() * 1_000_000) - start_time
                file.write(f"{elapsed_time_us:.0f}\n")

except KeyboardInterrupt:
    print("\n Enregistrement interrom)
